﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage, 
		    [Parameter(Mandatory=$false)]
		    $Component, 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

$tsenv = New-Object -ComObject Microsoft.SMS.TSEnvironment
$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"

$Mode = $tsenv.Value('SMSTS_TSWaaSMode') #This Var is set at the start of each TS
if ($Mode -ne $null)
    {
    if ($Mode -eq "Upgrade")
    {
    $CurrentOSInfo = Get-Item -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion'
    $ReleaseID_CurrentOS = $CurrentOSInfo.GetValue('ReleaseId')
    if ($ReleaseID_CurrentOS -eq $tsenv.Value('SMSTS_Build'))
        {
        $ComponetSuffix = "PostSetup"
        }
    Else
        {
        $ComponetSuffix = "PreSetup"
        }    
    $Component = "$($mode):LP:$($ComponetSuffix)"
    }
    Else
        {$Component = "$($mode):LP"}
    }
else {$Component = "LangPack"}

$AdditionalArgs = $tsenv.Value('OSDSetupAdditionalUpgradeOptions')

write-output "Additional Setup Args: $($AdditionalArgs)"
CMTraceLog -Message "Additional Setup Args: $($AdditionalArgs)" -Type 1 -LogFile $LogFile -Component $Component